﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
	public partial class DiskImage
	{

        public DiskImage()
        {
        }

        public DiskImage(DiskImageBase diskImageBase) 
        {
            ParentId = Guid.Empty;
            volume_type = diskImageBase.volume_type;
            volume_format = diskImageBase.volume_format;
            disk_type = diskImageBase.disk_type;
            size = diskImageBase.size;
            internal_drive_mapping = diskImageBase.internal_drive_mapping;
            disk_interface = diskImageBase.disk_interface;
            boot = diskImageBase.boot;
            wipe_after_delete = diskImageBase.wipe_after_delete;
            propagate_errors = diskImageBase.propagate_errors;            
        }

        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return Id; }
        }

		private static readonly List<string> _diskImageProperties =
			new List<string> 
                { "active", "creation_date", "last_modified_date", "actual_size",
                  "description", "internal_drive_mapping", "appList", "it_guid", 
                  "vm_guid", "ParentId", "imageStatus", "lastModified", "storage_id",
                  "vm_snapshot_id", "storage_path", "image_group_id", "storage_pool_id", "boot",
				  "volume_type", "volume_format", "disk_interface", "wipe_after_delete", "propagate_errors", "read_rate", "write_rate", "ActualSize"
                };

        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _diskImageProperties; }
        }

        #endregion
    }
	
    public partial class DiskImageBase
	{
        public DiskImageBase()
        {
            volume_type = VolumeType.Sparse;
            volume_format = VolumeFormat.COW;
            disk_type = DiskType.System;
            size = 0;
            disk_interface = DiskInterface.IDE;
            propagate_errors = PropagateErrors.Off;
        }

      
        [XmlIgnoreAttribute]
		public long SizeInGigabytes
        {
            get
            {
				return size / (1024 * 1024 * 1024);
            }
            set
            {
				size = value * (1024 * 1024 * 1024);
            }
        }
    }
}
